# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 6
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR6_strategy.txt
# LLM Suggested Fallback: D

def serendipitous_ally(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Start with cooperation to establish goodwill
    
    # Analyze opponent's code for unconditional strategies
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"  # Exploit always-C opponents
    if always_d:
        return "C" if len(my_history) % 2 == 0 else "D"  # Alternate to minimize losses
    
    # Delayed tit-for-tat with occasional testing defections
    if len(my_history) >= 2:
        if opp_history[-1] == "D":
            return "D"  # Retaliate if opponent defected last round
        if len(my_history) % 4 == 0:
            return "D"  # Test opponent's tolerance every 4th round
    
    # Default to cooperation if no conditions met
    return "C"